import java.net.*;
import java.io.*;

public class ChatServerCommThread extends Thread
{
  protected Socket socket;
  protected ChatServerConsole cscon;
  protected BufferedReader brinp = null;
  protected DataOutputStream out = null;
  public String nick = null;
  public String threadName;
  public boolean stopped = false;
  public ChatServerCommThread(ChatServerConsole cscon, 
                              Socket socket)
  {
    this.socket = socket;
    this.cscon = cscon;
    threadName = getName();
  }
  public void run()
  {    
    //inicjalizacja strumieni
    try{
      brinp = new BufferedReader(
        new InputStreamReader(
          socket.getInputStream()
        )
      );
      out = new DataOutputStream(socket.getOutputStream());
    }
    catch(IOException e){
      cscon.log(threadName + "| Bd przy tworzeniu strumieni " + e);
      cscon.removeThread(this);
      return;
    }
    String line = null;
    
    //ptla gwna
    while(!stopped){
      try{
        line = brinp.readLine();
        cscon.log(threadName + "| Odczytano lini: " + line);

        //osignity koniec strumienia (brak poczenia)
        if(line == null){
          cscon.log(threadName + 
            "| Zakoczenie pracy z klientem: " + socket);
          break;
        }
        else{
          processMessage(line);
        }
      }
      catch(IOException e){
        cscon.log(threadName + "| Bd wejcia-wyjcia: " + e);
        break;
      }
    }
    
    //koczenie pracy wtku
    try{
      if(!socket.isClosed()) socket.close();
    }
    catch(IOException e){}
    stopped = true;
    cscon.removeThread(this);
    cscon.log(threadName + "| Wtek zatrzymany.");
  }
  public void processMessage(String line)
  {
    cscon.log(threadName + "| Przetwarzam lini: " + line);
    sendToAll(line);
  }

  public void send(String line)
  {
    try{
      out.writeBytes(line + "\n");
      cscon.log(threadName + "| Wysano: " + line);
    }
    catch(IOException e){
      cscon.log(threadName + "| Bd wejcia-wyjcia: " + e);
    }
  }
  public void sendToAll(String line){
    synchronized(cscon.threadList){
      for (int i = 0; i < cscon.threadList.size(); i++){
          cscon.threadList.elementAt(i).send(line);
      }
    }
  }
  public void interrupt()
  {
    super.interrupt();
    try{
      socket.close();
    }
    catch(IOException e){}
  }
  public String getInfo()
  {
    String info = this.getName() + "| ";
    info += "IP " + socket.getInetAddress().getHostAddress() + " ";
    info += "Port " + socket.getPort() + " ";
    info += "nick:" + ((nick != null)?nick:"-");
    return info;
  }
}
